import astropy.io.fits as fits

import numpy as np

from pathlib import Path

def GTIHeader(refdata):
    reffile = refdata + 'gti.txt'
    if not Path(reffile).exists():
        print(f"File {reffile} not found")
    else:
        reffile = Path(reffile)
    hdr = fits.Header.fromtextfile(reffile)
    return hdr

def BBlockHeader(refdata):
    reffile = refdata + 'bb_data.txt'
    if not Path(reffile).exists():
        print(f"File {reffile} not found")
    else:
        reffile = Path(reffile)
    hdr = fits.Header.fromtextfile(reffile)
    return hdr    
    
def bb_table(bb_lc,bb_index,trigtime,refdata):
    """
    bb_lc (TimeBins): Bayesian Blocks lightcurve
    bb_index : Bayesian blocks indices
    """
    tstart = np.copy(bb_lc.lo_edges)
    tstop  = np.copy(bb_lc.hi_edges)
    counts = bb_lc.counts
    exposure=bb_lc.exposure
    bb_index=bb_index[1:]
    
    if trigtime is not None:
        tstart += trigtime
        tstop += trigtime
    else:
        trigtime = 0.
      
    start_col = fits.Column(name='START', format='1D', unit='s', 
                            array=tstart)
                            
    stop_col = fits.Column(name='STOP', format='1D', unit='s', 
                           array=tstop)
              
    count_col = fits.Column(name='COUNTS', format='1J', array=counts, unit='count')
    
    exp_col  = fits.Column(name='EXPOSURE', format='1E', array=exposure,
                            unit='s')
    
    bind_col = fits.Column(name='BINDEX', format='1J', array=bb_index)
    
    hdu = fits.BinTableHDU.from_columns([start_col,stop_col,count_col,exp_col,bind_col])
    hdu.header.update(BBlockHeader(refdata))

    return hdu

def gti_table(tstart,tstop,trigtime,refdata):

    tstart = np.array(tstart)
    tstop  = np.array(tstop)
    if trigtime is not None:
        tstart += trigtime
        tstop += trigtime
    else:
        trigtime = 0.

    start_col = fits.Column(name='START', format='1D', unit='s', 
                             array=tstart)
    stop_col = fits.Column(name='STOP', format='1D', unit='s', 
                           array=tstop)
    hdu = fits.BinTableHDU.from_columns([start_col, stop_col])
    
    hdu.header.update(GTIHeader(refdata))
     
    return hdu       
