# Basic input/output routines that get called in multiple tasks

import numpy as np
from pathlib import Path

## Function to check if file already exists
## If clobber!=yes and file exists, prints error and returns 1
def clob_check(clobber,filename,logger):
    if clobber==False and Path(filename).exists():
        logger.error(f'File {filename} already exists.')
        logger.error('Set clobber=yes to overwrite files.')
        return 1
    else:
        return 0
    
## Function that checks whether string starts with @ or is comma-separated list
## Useful for input of event, ebounds, and rebin files
def get_filelist(filelist,logger):
    if filelist.startswith('@'):
        # Remove '@' from start of file and check that it exists
        list_file = Path(filelist[1:])
        if list_file.exists():
            # Load list of files from text file
            file_list = np.loadtxt(list_file, dtype='str')
        else:
            # Output error if file does not exist
            logger.error(f"The file {list_file} does not exist.")
            return 1
    else:
        # If it does not start with '@', it should be of the form 'file1,file2,file3...'
        # Separate string by commas to get list of input files
        file_list = np.array(filelist.split(','))
    
    return file_list

## Function to check filename for extension at end, defaults to 1
## Returns filename and extension number
def file_extn(filename):
    if '+' in filename:
        filename, extension_str = filename.split('+')
    elif '[' in filename and ']' in filename:
        filename, extension_str = filename.split('[')
        extension_str = extension_str.rstrip(']')
    else:
        extension_str = '1'

    try:
        # Parse extension number
        extension = int(extension_str)
    except ValueError:
        raise ValueError(f"Invalid extension value ({extension_str}) for {filename}")
    
    return filename,extension