import astropy.io.fits as fits

import numpy as np

from pathlib import Path


def LCPrimHeader(REFDATA):
    reffile = REFDATA + 'primary.txt'
    if not Path(reffile).exists():
        print(f"File {reffile} not found")
    else:
        reffile = Path(reffile)
    hdr = fits.Header.fromtextfile(reffile)
    return hdr

def LCDataHeader(REFDATA):
    reffile = REFDATA + 'lc_data.txt'
    if not Path(reffile).exists():
        print(f"File {reffile} not found")
    else:
        reffile = Path(reffile)
    hdr = fits.Header.fromtextfile(reffile)
    return hdr
    
    
def lc_table(lightcurve,bkg_lc,bkg_err,trigtime,refdata):
    times = np.copy(lightcurve.hi_edges)

    times += trigtime

    time_col = fits.Column(name='TIME', format='1D',
                           unit='s', array=times)
    
    rate =  lightcurve.rates - bkg_lc
    rate_err = np.sqrt(lightcurve.rate_uncertainty**2 + bkg_err**2)
              
    rate_col = fits.Column(name='RATE', format='1E', array=rate, unit='count/s')
    
    err_col  = fits.Column(name='ERROR', format='1E', array=rate_err,
                            unit='count/s')
    
    tot_col = fits.Column(name='TOTRATE', format='1E', array=lightcurve.rates, unit='count/s')
    
    tote_col = fits.Column(name='TOTRATE_ERROR', format='1E', array=lightcurve.rate_uncertainty, unit='count/s')
    
    bkg_col = fits.Column(name='BKGRATE', format='1E', array=bkg_lc, unit='count/s')
    
    bkge_col = fits.Column(name='BKG_ERROR', format='1E', array=bkg_err, unit='count/s')
    
    hdu = fits.BinTableHDU.from_columns([time_col, rate_col, err_col, tot_col,tote_col,bkg_col,bkge_col])
    hdu.header.update(LCDataHeader(refdata))

    return hdu
        
