#!/usr/bin/env python
#
#  This task calculates the BURSTCUBE occultation map based on the input
#  orbital data and the good time intervals.   
#  The output file contains in the primary header teh AIT projection of
#  the map and a HEAPIX reprrsenation in the 1st extension. 
#  The map values are 0=not occulted 1=occulted.
#
#  This code can be run on a command line under the ftools enviroment
#  Version is recorded in bcoccult_task.py
#  James Runge (ADNET) Feb 2024
#  

import sys
import heasoftpy as hsp
from heasoftpy import burstcube


if __name__ == '__main__':
    
    task = burstcube.BCOccultTask(name='bcoccult')
    cmd_args = hsp.utils.process_cmdLine(task)
    result = task(**cmd_args)
    sys.exit(result.returncode)