#!/usr/bin/env python

#
#  This task rebins the event file in time and energy and output a file equally
#  space in time where each row contains: a)  a time column, b) a column containing
#  a spectra array and c)  a column with the sum of the array.
#  If the input file has already a format with time column and a column with a spectral array
#  in each row equally space in time the output is identical to the input with an additional
#  column containg the sum.  
#  In both cases the output contains two additional extensions: gti and ebounds.
#  Last, the task creates a plot of the spectrum and lightcurve of  the output file 
#  This code can be run on a command line under the ftools enviroment  
#  Version is recorded in bcrebevt_task.py
#  James Runge (ADNET)
#

import sys
import heasoftpy as hsp
from heasoftpy import burstcube


if __name__ == '__main__':
    
    task = burstcube.BCRebEvtTask(name='bcrebevt')
    cmd_args = hsp.utils.process_cmdLine(task)
    result = task(**cmd_args)
    sys.exit(result.returncode)