#!/usr/bin/env python
#
#
#  This task calculates the start and stop of different intervals associated to the burst.
#  The output FITS file containing 5 extensions formatted as good time intervals :
#   1-  total time interval of the burst where the start and stop are defined as the 1st Bayesian block
#        and last Bayesian  block above background  respectively
#   2- T90 defined as the 90% of the flux with the total time interval 
#   3- T50 defined as the 50% of teh flux with the total time interval
#   4- Peak defined as the time interval with the highest number of counts in the combined
#      lightcurve within the total time interval
#   5- Background time interval determined within this task
#
#  The input data are the spectra accumulated every XX sec and binned YY channels as the
#  output of bcrebevt
#
#  The task also ouputs :
#    a)  plot file of the combined lightcurve (sum of all detectors) with  the Bayesian block,
#         the start and stop of the total burst, and the background level overplotted.
#    b) Lightcurve of the combined data as FITS file and ASCII file
#    c) Bayesian block as FITS files
#
#
#  This code can be run on a command line under the ftools enviroment
#  Version is recorded in bcrebevt_task.py
#  James Runge (ADNET)  Feb 2024 


#
import sys
import heasoftpy as hsp
from heasoftpy import burstcube


if __name__ == '__main__':
    
    task = burstcube.BCTimebstTask(name='bctimebst')
    cmd_args = hsp.utils.process_cmdLine(task)
    result = task(**cmd_args)
    sys.exit(result.returncode)