#
#  This is grabbing the parameter file and passing the
#  paramters to the task. Only used in the heasoft 
#  enviroment 
#  James Runge (ADNET)
#
#

import sys
import logging
import datetime

from heasoftpy import HSPTask, HSPResult
from heasoftpy import fcn, utils

from heasoftpy.burstcube import bctimebst_task

class BCTimebstTask(HSPTask):
    """Sample python-based task"""
    
    name = 'bctimebst'
    
    def exec_task(self):
        
        # put the parameters in to a list of par=value
        params = self.params
        infile = self.params['infile']
        outprefix = self.params['outprefix']
        timecol= self.params['timecol']
        cntscol= self.params['cntscol']
        emin   = self.params['emin']
        emax   = self.params['emax']
        fprob  = self.params['fprob']
        poly   = self.params['poly']
        niter  = self.params['niter']
        bnum   = self.params['bnum']
        refdata= self.params['refdata']
        chatter= self.params['chatter']
        log    = self.params['log'] in ['yes','y',True]
        clob   = self.params['clobber'] in ['yes','y',True]

        # logger
        logger = logging.getLogger('bctimebst')
        # Set level based upon chatter level
        # Create dictionary to set level according to chatter value
        chat_level = {0:40,1:20,5:10}
        # Chatter values 1 through 4 are all the same
        if 1 <= chatter <= 4:
            chatter = 1
        
        # If log file is wanted
        if log == True:
            # Create a file handler and set the logging level
            # Get current date and time
            now = datetime.datetime.now()
            date_time = now.strftime("%d%m%Y_%H%M%S")
            log_filename = f'{self.name}_{date_time}.log'
            file_handler = logging.FileHandler(log_filename)
            # Create a formatter and add it to the handlers
            formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
            file_handler.setFormatter(formatter)
            file_handler.setLevel(chat_level[chatter])
            logger.addHandler(file_handler)
        # or logger = self.logger
        # or logger = logging.getLogger('template')
        
        # return code: 0 if task runs sucessful; set to 0 at the end
        returncode = 1
        
        
        ## ----------------- ##
        ##  start code here  ##
        ## ----------------- ##

        # Pass to python task
        
        returncode = bctimebst_task.bctimebst(infile,outprefix,timecol,cntscol,emin,emax,fprob,poly,niter,bnum,refdata,chatter,clob)
        
        ## ----------------- ##
        ##  end code  ##
        ## ----------------- ##
        
        outMsg, errMsg = self.logger.output
        
        return HSPResult(returncode, outMsg, errMsg, params)
    
    
    def task_docs(self):
        """Leave like this to use the docstring in the task method below 
        This is the help text to be printed when passing -h to the command 
        line executable of the task
        """
        return bctimebst.__doc__
    


def bctimebst(args=None, **kwargs):
    """
    Write your task help text here.
    
    """
    bctime_task = BCTimebstTask('bctimebst')
    result = bctime_task(args, **kwargs)
    return result

