import os, stat
from pathlib import Path
import shutil
from datetime import datetime


now = datetime.now()
newstr = now.strftime("%Y%m%d%H%M%S")


# Step 1: Update __init__.py under $HEADAS/lib/python/heasoftpy/ixpe
try:
    headas = os.environ['HEADAS']
except:
    headas = input("Can't find your HEASoft environment, if you know the HEADAS PATH, please enter it here:")

heapath = Path(headas)
arch_str = heapath.parts[-1]

ixpepath = Path(headas)/"lib/python/heasoftpy/ixpe"


if not ixpepath.exists():
    print(f"attempting to find {ixpepath} but it doesn't exist...")
    sys.exit("you don't have ixpe tasks in HEASoft, please check your HEASoft installation.")

filename = "__init__.py"

filepath = ixpepath/filename
if not filepath.exists():
    print(f"attempting to find {filepath} but it doesn't exist...")
    sys.exit("Something is wrong with your ixpe tasks in HEASoft, please check your HEASoft installation.")
    
backuppath = Path(f"./backup{newstr}__init__.py")
print(f"!!! Making a copy of \n{filepath} to \n\n{backuppath}...\n\n\n")
print(f"!!! Please revert it back to\n {filepath} if something goes wrong. \n\n\n")

shutil.copy(filepath, backuppath)


code_for_all = ''
addimport = True
addall = True
with open(filepath,'r') as f:
    lines = f.readlines()
    
linecounter = 0
id_last_import = 1
with open(filepath,'r') as f:
    for line in f:
        if 'ixpeproduct_lib' in line:
            addimport = False
        if not 'from .ixpe' in line:
            if (id_last_import == 1) and len(line) > 1:
                id_last_import = linecounter - 1
            code_for_all += line
        linecounter += 1

code_for_exe = code_for_all.replace('\n','')
exec(code_for_exe)
if "ixpeproduct" in __all__:
    addall = False

if addimport:
    newline = "from .ixpeproduct_lib import ProductTask, IxpeProduct_Util"
    lines.insert(id_last_import+1, newline + '\n')
    lines.insert(id_last_import+2, '\n')
    with open(filepath, 'w') as f:
            f.writelines(lines)
    print(f"added ixpeproduct related imports to __init__.py for HEASoft's IXPE software")

if addall:
    bracketchar = "]"
    insert_product = ",'ixpeproduct']"      # The character to replace it with
    with open(filepath, 'r') as f:
        content = f.read()
        count = content.count(bracketchar)
        if count == 1:
            print('replaced')
            content = content.replace(bracketchar, insert_product)
        else:
            print("can't add ixpeproduct to your __all__ in __init__.py. Please do it manually.")

    with open(filepath, 'w') as f:
            f.write(content)
    print(f"added ixpeproduct to the IXPE Task")


# Step 2: Copy ixpeproduct related python files to $HEADAS/lib/python/heasoftpy/ixpe
parpath = Path(headas)/"syspfiles"
binpath = Path(headas)/"bin"
try:
    ixpebinpath = heapath.parent/"ixpe"/arch_str/"bin"
    assert ixpebinpath.exists()
except AssertionError:
    # for those who downloaded precompiled binaries...
    ixpebinpath = heapath/"bin"

productfilepath = Path('./ixpeproduct.py')
libfilepath = Path('./ixpeproduct_lib.py')
utilfilepath = Path('./product_util.py')
parfilepath = Path('./ixpeproduct.par')

print(f"copying ixpeproduct related files to HEASoft")
shutil.copy(libfilepath, ixpepath)
shutil.copy(utilfilepath, ixpepath)
print(f"adding ixpeproduct to the HEASoft IXPE binary path")
shutil.copy(productfilepath, ixpebinpath)
print(f"adding ixpeproduct.par to the HEASoft syspfiles path")
shutil.copy(parfilepath, parpath)

if not (binpath/productfilepath.parts[-1].replace('.py','')).exists():
    print(f"adding a soft link of ixpeproduct.py to the HEASoft binary path as ixpeproduct")
    os.symlink(ixpebinpath/productfilepath.parts[-1], binpath/productfilepath.parts[-1].replace('.py',''))


ixpebinfilepath = ixpebinpath/productfilepath.parts[-1]
# We also need to make the productfile an executable
print(f"adding execute permission to ixpeproduct.py to the HEASoft syspfiles path")
os.chmod(ixpebinfilepath, os.stat(productfilepath).st_mode | stat.S_IXUSR)



