
# README for ixpeproduct

ixpeproduct is a IXPE data analysis tool being developed by the IXPESOC. It is currently planned to be fully integrated
to HEASoft during the second update of 2025. We've prepared a beta-test version of the tool for the IXPE community to access before the next HEASoft update. 

ixpeproduct is a wrapper for the following HEASoft tools, it extracts spectra, light curves with HEASoft extractor. It also
calculates polarization measurements with ixpepolarization. For the generated spectra, it also generates the corrected response files
and place them in the product folder. The background and response file names are added to the header of spectral files when appropriate. 

```couchbasequery
ixpepolarization
extractor
ixpecalcarf
ixpemkxspec
```


## Installation 
List of files:
```bash
addixpeproduct.py
ixpeproduct_lib.py
ixpeproduct.py
product_util.py
ixpeproduct.par
```

To integrate ixpeproduct into your existing HEASoft installation, please make sure you have access to add/modify files in your $HEADAS folder. 
Once you've initialized HEASOft, you can run the following command in the folder with the ixpeproduct related files:

```bash
python addixpeproduct.py
```

This will copy the files to the corresponding paths under $HEADAS and should make ixpeproduct an executable FTOOL just like the other IXPE tasks. 
Note the script will make a back up of the following file and then modifies it:
```bash
$HEADAS/lib/python/heasoftpy/ixpe/__init__.py 
```
In case you want to revert this change, please copy the backup file (named as backupYYYYMMDDHHMMSS__init__.py in your current path) back to $HEADAS/lib/python/heasoftpy/ixpe/__init__.py.


Once ixpeproduct is installed, you can call it as an FTOOL, commands such as plist, fhelp should work as well. 

## Example
The following ixpeproduct command is an example for extracting spectra, and polarization measurements for IXPE Obsid 03250701.
The output files will be saved under ixpeproduct_03250701 (the product folder will be generated automatically if necessary). 


```bash
ixpeproduct indir=./03250701 outdir=ixpeproduct_03250701 backrej=yes srcregfile=./3c273_ixpe_src.reg \
bgregfile=./3c273_ixpe_bg.reg weight=1 clobber=yes backrej=yes
```



#### Background rejection: 
If you set backrej=yes, ixpeproduct will attempt to reject background events flagged in the level 2 event list. 
For the above example, the observations was taken after the IXPE processing pipeline updates that automatically flags the 
instrumental background events according to the Di Marco et al. (2023) algorithm. 
Note that for events before [DATE], this option will not have any effect since only observations after this data were 
processed with the new pipeline with built-in background rejection. 
For observations before this date, you can still run the publicly available background rejection script 
(https://github.com/aledimarco/IXPE-background). 
If your background rejected events follows the naming convention of "*evt2_rej*.fits" and are in the same location as the regular event lists, 
backrej=yes will still work. 
Alternatively, you can parse the background rejected events as arguments with evtfiles, 
but the you will need to set backrej=no for this option. Please see the example script for this scenario:
```bash
ixpeproduct indir=02004601 outdir=product_02004601 backrej=no \
evtfiles="02004601/event_l2/ixpe02004601_det1_evt2_v02_rej.fits,02004601/event_l2/ixpe02004601_det2_evt2_v02_rej.fits,02004601/event_l2/ixpe02004601_det3_evt2_v02_rej.fits" \
srcregfile=mrk501_src_02004601.reg bgregfile=mrk501_bg_02004601.reg weight=1
```

#### ixpepolarization and light curve
By default, ixpeproduct generates light curves and polarization measurements for events with energy between 2 to 8 keV. 
It is possible to modify the energy range for these two products with en_lo and en_up arguments. Alternatively, pi_lo and pi_up
also works. 

```bash
ixpeproduct indir=./03250701 outdir=ixpeproduct_03250701 backrej=yes srcregfile=./3c273_ixpe_src.reg \
bgregfile=./3c273_ixpe_bg.reg weight=1 clobber=yes backrej=yes en_lo=4.0 en_up=8.0
```

